//Caption: Sampling and Reconstruction of a Signal x(t) = exp(-A*|t|) 
//Discrete Time Sampled Signal x(nT)= exp(-A*|nT|)
//Following Sampling Frequencies are used:
//[1].Fs = 1 Hz [2].Fs = 2 Hz [3].Fs = 4Hz [4].Fs =20 Hz [5].Fs =100Hz 
//Aliasing Effect: As the Sampling frequency increases aliasing effect decreases
clear;
clc;
close;
// Analog Signal
A =1;    //Amplitude
Dt = 0.005;
t = -2:Dt:2;
//Continuous Time Signal
xa = exp(-A*abs(t));
//Discrete Time Signal
Fs =input('Enter the Sampling Frequency in Hertz');//Fs = 1Hz,2Hz,4Hz,20Hz,100Hz
Ts = 1/Fs;
nTs = -2:Ts:2;
x = exp(-A*abs(nTs));
// Analog Signal reconstruction
Dt = 0.005;
t = -2:Dt:2;
Xa = x *sincnew(Fs*(ones(length(nTs),1)*t-nTs'*ones(1,length(t))));
//Plotting the original signal and reconstructed signal
subplot(2,1,1);
a =gca();
a.x_location = "origin";
a.y_location = "origin";
plot(t,xa);
xlabel('t in sec.');
ylabel('xa(t)')
title('Original Analog Signal')
subplot(2,1,2);
a =gca();
a.x_location = "origin";
a.y_location = "origin";
xlabel('t in sec.');
ylabel('xa(t)')
title('Reconstructed Signal using sinc function, Fs = 100Hz'); 
plot(t,Xa);